<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0+
 * @link    http://my.studiopress.com/themes/genesis/
 */

/**
 * Registers a new admin page, providing content and corresponding menu item for the "What's new" page.
 *
 * @package Genesis\Admin
 *
 * @since 1.9.0
 */
class Genesis_Admin_Upgraded extends Genesis_Admin_Basic {

	/**
	 * Create the page.
	 *
	 * @uses PARENT_THEME_BRANCH      Genesis Framework branch.
	 * @uses \Genesis_Admin::create() Register the admin page.
	 *
	 * @since 1.9.0
	 */
	function __construct() {

		$page_id = 'genesis-upgraded';

		$menu_ops = array(
			'submenu' => array(
				'parent_slug' => 'admin.php',
				'menu_title'  => '',
				'page_title'  => sprintf( __( 'Welcome to Genesis %s', 'genesis' ), PARENT_THEME_BRANCH ),
			)
		);

		$this->create( $page_id, $menu_ops );

		add_action( 'admin_enqueue_scripts', 'add_thickbox' );

	}

	/**
	 * Callback for displaying the What's New admin page.
	 *
	 * @since 1.9.0
	 */
	public function admin() {

		?>
		<div class="wrap about-wrap">

		<img src="<?php echo get_template_directory_uri() . '/lib/admin/images/whats-new.png'; ?>" class="alignright whats-new" />

		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

		<div class="about-text"><?php printf( __( 'Congratulations! You\'re now running Genesis %s.', 'genesis' ), PARENT_THEME_BRANCH ); ?></div>

		<div class="changelog">
			<h2><?php _e( 'What&#8217;s New', 'genesis' ); ?></h2>
			<div class="feature-section">

				<h3><?php _e( 'Accessibility', 'genesis' ); ?></h3>
				<p><?php _e( 'Child themes now have the ability to turn on accessibility features like special text for screen readers, accessible search forms, consistent page and section headings, skip links, and an accessible drop-down navigation menu.', 'genesis' ); ?></p>

				<h3><?php _e( 'Schema.org Microdata Improvements', 'genesis' ); ?></h3>
				<p><?php _e( 'Genesis continues to improve its implementation of Schema.org microdata in our markup, now including breadcrumb microdata.', 'genesis' ); ?></p>

				<h3><?php _e( 'WordPress Feature Compatibility', 'genesis' ); ?></h3>
				<p><?php _e( 'WordPress recently included support for generated title tags, as well as adding support for uploading a custom site icon, and now Genesis is compatible with both new features.', 'genesis' ); ?></p>

				</div>
		</div>

		<div class="project-leads">

			<h2><?php _e( 'Project Leads', 'genesis' ); ?></h2>

			<ul class="wp-people-group " id="wp-people-group-project-leaders">
			<li class="wp-person">
				<a href="http://twitter.com/nathanrice"><img src="//0.gravatar.com/avatar/fdbd4b13e3bcccb8b48cc18f846efb7f?s=120" class="gravatar" alt="Nathan Rice" /></a>
				<a class="web" href="http://twitter.com/nathanrice">Nathan Rice</a>
				<span class="title"><?php _e( 'Lead Developer', 'genesis' ); ?></span>
			</li>
			<li class="wp-person">
				<a href="http://twitter.com/bgardner"><img src="//0.gravatar.com/avatar/c845c86ebe395cea0d21c03bc4a93957?s=120" class="gravatar" alt="Brian Gardner" /></a>
				<a class="web" href="http://twitter.com/bgardner">Brian Gardner</a>
				<span class="title"><?php _e( 'Lead Developer', 'genesis' ); ?></span>
			</li>
			</ul>

		</div>

		<div class="contributors">

			<h2><?php _e( 'Contributors', 'genesis' ); ?></h2>

			<ul class="wp-people-group" id="wp-people-group-contributing-developers">
			<?php
			$contributors = genesis_contributors();

			shuffle( $contributors );

			foreach ( $contributors as $contributor ) {
				echo '<li class="wp-person">';
				printf( '<a href="%s"><img src="%s" alt="%s" class="gravatar" /></a><a class="web" href="%s">%s</a>', esc_url( $contributor['url'] ), esc_url( $contributor['gravatar'] ), esc_attr( $contributor['name'] ), esc_url( $contributor['url'] ), esc_html( $contributor['name'] ) );
				printf( '<span class="title">%s</span>', __( 'Contributor', 'genesis' ) );
				echo '</li>' . "\n";
			}
			?>
			</ul>

		</div>

		<div class="return-to-dashboard">
			<p><a href="<?php echo esc_url( menu_page_url( 'genesis', 0 ) ); ?>"><?php _e( 'Go to Theme Settings &rarr;', 'genesis' ); ?></a></p>
			<?php
			if ( ! genesis_seo_disabled() ):
				?><p><a href="<?php echo esc_url( menu_page_url( 'seo-settings', 0 ) ); ?>"><?php _e( 'Go to SEO Settings &rarr;', 'genesis' ); ?></a></p><?php
			endif; ?>

		</div>

		</div>
		<?php

	}

}
