<?php
/**
 * This file adds the Home Page to the Tasteful Theme.
 *
 * @author Restored316
 * @package Generate
 * @subpackage Customizations
 */
 
add_action( 'genesis_meta', 'tasteful_home_genesis_meta' );
/**
 * Add widget support for homepage. If no widgets active, display the default loop.
 *
 */
function tasteful_home_genesis_meta() {

	if ( is_active_sidebar( 'home-slider' ) || is_active_sidebar( 'home-top' ) || is_active_sidebar( 'home-middle-left' ) || is_active_sidebar( 'home-bottom' ) ) {

		remove_action( 'genesis_loop', 'genesis_do_loop' );
		add_action( 'genesis_loop', 'tasteful_home_sections' );
		add_filter( 'genesis_pre_get_option_site_layout', '__genesis_return_content_sidebar' );
		add_filter( 'body_class', 'tasteful_add_home_body_class' );

	}
	
}

function tasteful_home_sections() {

	genesis_widget_area( 'home-slider', array(
		'before' => '<div class="home-slider widget-area">',
		'after'  => '</div>',
	) );

	genesis_widget_area( 'home-top', array(
		'before' => '<div class="home-top widget-area">',
		'after'  => '</div>',
	) );
	
	if ( is_active_sidebar( 'home-middle-left' ) || is_active_sidebar( 'home-middle-right' ) ) {

		echo '<div class="home-middle">';

		genesis_widget_area( 'home-middle-left', array(
			'before' => '<div class="home-middle-left widget-area">',
			'after'  => '</div>',
		) );

		genesis_widget_area( 'home-middle-right', array(
			'before' => '<div class="home-middle-right widget-area">',
			'after'  => '</div>',
		) );

		echo '</div>';
	
	}
	
		if ( is_active_sidebar( 'home-bottom' ) ) {

		echo '<div class="home-bottom">';

		genesis_widget_area( 'home-bottom', array(
			'before' => '<div class="home-bottom widget-area">',
			'after'  => '</div>',
		) );

		echo '</div>';
	
	}
	
}

//* Add body class to home page		
function tasteful_add_home_body_class( $classes ) {

	$classes[] = 'tasteful-home';
	return $classes;
	
}

genesis();
