<?php
//* Start the engine
require_once( get_template_directory() . '/lib/init.php' );

//* Add HTML5 markup structure
add_theme_support( 'html5' );

//* Add viewport meta tag for mobile browsers
add_theme_support( 'genesis-responsive-viewport' );

//* Enqueue Google fonts
add_action( 'wp_enqueue_scripts', 'tasteful_google_fonts' );
function tasteful_google_fonts() {

	wp_enqueue_style( 'google-font', '//fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,400italic,600,600italic,700italic,700|Raleway:400,300,500,600,700', array() );

}

//* Add new image sizes
add_image_size( 'blog-featured', 300, 300, TRUE );
add_image_size( 'home-left', 370, 220, TRUE );
add_image_size( 'home-right', 150, 150, TRUE );
add_image_size( 'sidebar-featured', 75, 75, TRUE );
add_image_size( 'slider', 740, 480, TRUE );
add_image_size( 'square-featured', 190, 190, TRUE );

//* Add support for custom background
add_theme_support( 'custom-background' );

//* Add support for custom header
add_theme_support( 'custom-header', array(
	'width'           => 300,
	'height'          => 130,
	'header-selector' => '.site-title a',
	'header-text'     => false
) );

//* Add support for additional color style options
add_theme_support( 'genesis-style-selector', array(
	'tasteful-sweet-cakes'  => __( 'Sweet Cakes', 'tasteful' ),
	'tasteful-veggie-green'  => __( 'Veggie Green', 'tasteful' ),
	'tasteful-cherry-pie' => __( 'Cherry Pie', 'tasteful' ),
	'tasteful-pink-lemonade' => __( 'Pink Lemonade', 'tasteful' ),
	'tasteful-gray' => __( 'Shades of Gray', 'tasteful' ),
) );

//* Add support for 3-column footer widgets
add_theme_support( 'genesis-footer-widgets', 4 );

//* Unregister layout settings
genesis_unregister_layout( 'content-sidebar-sidebar' );
genesis_unregister_layout( 'sidebar-content-sidebar' );
genesis_unregister_layout( 'sidebar-sidebar-content' );

//* Unregister secondary sidebar
unregister_sidebar( 'sidebar-alt' );

//* Hooks widget area above header
add_action( 'genesis_before', 'widget_above_header'  ); 
function widget_above_header() {

    genesis_widget_area( 'widget-above-header', array(
		'before' => '<div class="widget-above-header widget-area"><div class="wrap">',
		'after'  => '</div></div>',
    ) );

}

//* Reposition the secondary navigation
remove_action( 'genesis_after_header', 'genesis_do_subnav' );
add_action( 'genesis_before', 'genesis_do_subnav' );

//* Customize the post info function
add_filter( 'genesis_post_info', 'post_info_filter' );
function post_info_filter($post_info) {
if (!is_page()) {
    $post_info = '[post_date] by [post_author_posts_link] [post_comments]';
    return $post_info;
}}

/** Add post navigation (requires HTML5 support) */
add_action( 'genesis_entry_footer', 'genesis_prev_next_post_nav', 5 );

//* Hooks after-entry widget area to single posts
add_action( 'genesis_entry_footer', 'tasteful_after_post'  ); 
function tasteful_after_post() {

    if ( ! is_singular( 'post' ) )
    	return;

    genesis_widget_area( 'after-entry', array(
		'before' => '<div class="after-entry widget-area"><div class="wrap">',
		'after'  => '</div></div>',
    ) );

}

//* Add split sidebars underneath the primary sidebar
add_action( 'genesis_after_sidebar_widget_area', 'tasteful_split_sidebars' );
function tasteful_split_sidebars() {
	foreach ( array( 'sidebar-split-left', 'sidebar-split-right', 'sidebar-split-bottom' ) as $area ) {
		echo '<div class="' . $area . '">';
		dynamic_sidebar( $area );
		echo '</div><!-- end #' . $area . '-->';
	}
}

//* Modify the Genesis content limit read more link
add_filter( 'get_the_content_more_link', 'sp_read_more_link' );
function sp_read_more_link() {
	return '... <a class="more-link" href="' . get_permalink() . '">read more</a>';
}

//* Set Genesis Responsive Slider defaults
add_filter( 'genesis_responsive_slider_settings_defaults', 'tasteful_responsive_slider_defaults' );
function tasteful_responsive_slider_defaults( $defaults ) {

	$args = array(
		'location_horizontal'             => 'Left',
		'location_vertical'               => 'Top',
		'posts_num'                       => '5',
		'slideshow_excerpt_content_limit' => '100',
		'slideshow_excerpt_content'       => 'full',
		'slideshow_excerpt_width'         => '30',
		'slideshow_height'                => '480',
		'slideshow_more_text'             => __( 'Read More', 'tasteful' ),
		'slideshow_title_show'            => 1,
		'slideshow_width'                 => '740',
	);

	$args = wp_parse_args( $args, $defaults );
	
	return $args;
}

//* Customize the credits 
add_filter('genesis_footer_creds_text', 'custom_footer_creds_text');
function custom_footer_creds_text() {
    echo '<div class="creds"><p>';
    echo 'Copyright &copy; ';
    echo date('Y');
    echo ' &middot; <a target="_blank" href="http://restored316designs.com/themes">Tasteful theme</a> by <a target="_blank" href="http://www.restored316designs.com">Restored 316</a>';
    echo '</p></div>';

}

//* Register widget areas
genesis_register_sidebar( array(
	'id'			=> 'sidebar-split-left',
	'name'			=> __( 'Sidebar Split Left', 'tasteful' ),
	'description'	=> __( 'This is the left side of the split sidebar', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'			=> 'sidebar-split-right',
	'name'			=> __( 'Sidebar Split Right', 'tasteful' ),
	'description'	=> __( 'This is the right side of the split sidebar', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'			=> 'sidebar-split-bottom',
	'name'			=> __( 'Sidebar Split Bottom', 'tasteful' ),
	'description'	=> __( 'This is the bottom of the split sidebar', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'          => 'home-slider',
	'name'        => __( 'Home - Slider', 'tasteful' ),
	'description' => __( 'This is the slider section on the home page.', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'          => 'home-top',
	'name'        => __( 'Home - Top', 'tasteful' ),
	'description' => __( 'This is the top section of the home page.', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'          => 'home-middle-left',
	'name'        => __( 'Home - Middle Left', 'tasteful' ),
	'description' => __( 'This is the middle left section of the home page.', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'          => 'home-middle-right',
	'name'        => __( 'Home - Middle Right', 'tasteful' ),
	'description' => __( 'This is the middle right section of the home page.', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'          => 'home-bottom',
	'name'        => __( 'Home - Bottom', 'tasteful' ),
	'description' => __( 'This is the bottom section of the home page.', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'          => 'category-index',
	'name'        => __( 'Category Index', 'tasteful' ),
	'description' => __( 'This is the category index for the category index page template.', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'			=> 'widget-above-header',
	'name'			=> __( 'Widget Above Header', 'tasteful' ),
	'description'	=> __( 'This is the widget area above the header', 'tasteful' ),
) );
genesis_register_sidebar( array(
	'id'			=> 'after-entry',
	'name'			=> __( 'After Entry', 'tasteful' ),
	'description'	=> __( 'This is the after post on single entries', 'tasteful' ),
) );
